<?php

?><section class="pt-20 pb-24">
    <div class="max-w-6xl mx-auto px-4 space-y-10">
        <div class="text-center space-y-3">
            <h1 class="text-3xl md:text-4xl font-semibold">Student Friendly VPS</h1>
            <p class="text-slate-400 text-sm md:text-base max-w-2xl mx-auto">
                VPS murah terintegrasi DigitalOcean, cocok untuk pelajar, bot, dan project kecil.
            </p>
        </div>

        <div class="grid md:grid-cols-3 gap-6">
            <?php foreach ($plans as $plan): ?>
                <div class="pricing-card flex flex-col justify-between">
                    <div class="space-y-3">
                        <div class="flex items-center justify-between">
                            <h2 class="text-lg font-semibold"><?php echo htmlspecialchars($plan->name); ?></h2>
                            <span class="px-2 py-0.5 rounded-full bg-emerald-500/10 text-emerald-400 text-[11px] uppercase tracking-wide">
                                DigitalOcean
                            </span>
                        </div>
                        <div class="text-3xl font-semibold">
                            Rp<?php echo number_format($plan->price, 0, ',', '.'); ?>
                            <span class="text-xs text-slate-400 font-normal">/bulan</span>
                        </div>
                        <ul class="space-y-1.5 text-xs text-slate-300">
                            <li><?php echo $plan->memory; ?> MB RAM</li>
                            <li><?php echo $plan->cpu; ?> vCPU</li>
                            <li><?php echo $plan->disk; ?> GB SSD</li>
                            <li>
                                Lokasi <?php echo isset($doConfig['region']) ? strtoupper($doConfig['region']) : 'SGP1'; ?>
                            </li>
                            <li>Panel DigitalOcean langsung</li>
                        </ul>
                    </div>
                    <form method="post" action="<?php echo $baseUrl; ?>/vps/order" class="mt-6 space-y-3">
                        <input type="hidden" name="plan_id" value="<?php echo $plan->id; ?>">
                        <div class="text-left space-y-1">
                            <label class="text-[11px] text-slate-400">Nama VPS</label>
                            <input type="text" name="server_name" class="input" placeholder="contoh: vps-<?php echo htmlspecialchars($plan->slug); ?>">
                        </div>
                        <?php $images = $doConfig['images'] ?? []; ?>
                        <?php if (!empty($images)): ?>
                            <div class="text-left space-y-1">
                                <label class="text-[11px] text-slate-400">Image</label>
                                <select name="image_slug" class="input bg-black/40 text-xs">
                                    <?php foreach ($images as $image): ?>
                                        <option value="<?php echo htmlspecialchars($image['slug']); ?>">
                                            <?php echo htmlspecialchars($image['label']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        <?php endif; ?>
                        <button type="submit" class="btn-primary w-full text-xs">
                            Order VPS
                        </button>
                    </form>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
