<?php

?><header class="fixed top-0 left-0 right-0 z-40">
    <div class="backdrop-blur-xl bg-black/40 border-b border-white/5">
        <div class="max-w-6xl mx-auto px-4 py-4 flex items-center justify-between">
            <a href="<?php echo $baseUrl; ?>/" class="flex items-center gap-2">
                <div class="h-8 w-8 rounded-xl bg-primary/20 border border-primary/60 flex items-center justify-center">
                    <span class="text-primary font-bold text-xl">S</span>
                </div>
                <div class="flex flex-col leading-tight">
                    <span class="font-semibold tracking-tight">Sherif Cloud</span>
                    <span class="text-xs text-slate-400">Next Generation Bot Hosting</span>
                </div>
            </a>
            <nav class="hidden md:flex items-center gap-6 text-sm">
                <a href="<?php echo $baseUrl; ?>/#features" class="nav-link">Fitur</a>
                <a href="<?php echo $baseUrl; ?>/pricing" class="nav-link">Bot Hosting</a>
                <a href="<?php echo $baseUrl; ?>/vps" class="nav-link">VPS Murah</a>
                <a href="<?php echo $baseUrl; ?>/#status" class="nav-link">Status</a>
                <?php if ($authUser): ?>
                    <a href="<?php echo $baseUrl; ?>/dashboard" class="nav-link">Dashboard</a>
                <?php endif; ?>
            </nav>
            <div class="flex items-center gap-3">
                <?php if ($authUser): ?>
                    <form method="post" action="<?php echo $baseUrl; ?>/logout">
                        <button type="submit" class="btn-ghost text-sm">Logout</button>
                    </form>
                <?php else: ?>
                    <a href="<?php echo $baseUrl; ?>/login" class="btn-ghost text-sm hidden sm:inline-flex">Login</a>
                    <a href="<?php echo $baseUrl; ?>/register" class="btn-primary text-sm">Get Started</a>
                <?php endif; ?>
                <button id="nav-toggle" class="md:hidden inline-flex items-center justify-center h-9 w-9 rounded-lg border border-white/10 bg-black/40">
                    <span class="sr-only">Menu</span>
                    <div class="space-y-1.5">
                        <span class="block h-0.5 w-5 bg-white"></span>
                        <span class="block h-0.5 w-5 bg-white"></span>
                    </div>
                </button>
            </div>
        </div>
        <div id="mobile-menu" class="md:hidden max-w-6xl mx-auto px-4 pb-4 hidden">
            <nav class="flex flex-col gap-2 text-sm">
                <a href="<?php echo $baseUrl; ?>/#features" class="nav-link">Fitur</a>
                <a href="<?php echo $baseUrl; ?>/pricing" class="nav-link">Bot Hosting</a>
                <a href="<?php echo $baseUrl; ?>/vps" class="nav-link">VPS Murah</a>
                <a href="<?php echo $baseUrl; ?>/#status" class="nav-link">Status</a>
                <?php if ($authUser): ?>
                    <a href="<?php echo $baseUrl; ?>/dashboard" class="nav-link">Dashboard</a>
                <?php else: ?>
                    <a href="<?php echo $baseUrl; ?>/login" class="nav-link">Login</a>
                    <a href="<?php echo $baseUrl; ?>/register" class="nav-link">Get Started</a>
                <?php endif; ?>
            </nav>
        </div>
    </div>
    <div class="h-20"></div>
</header>
