<?php

?><section class="pt-10 pb-20">
    <div class="max-w-6xl mx-auto px-4 grid md:grid-cols-2 gap-12 items-center">
        <div class="space-y-6">
            <span class="inline-flex items-center gap-2 rounded-full border border-primary/40 bg-primary/10 px-3 py-1 text-xs text-primary">
                <span class="h-1.5 w-1.5 rounded-full bg-primary animate-pulse"></span>
                <span>Next Generation Bot Hosting</span>
            </span>
            <h1 class="text-4xl md:text-5xl font-semibold tracking-tight">
                Sherif Cloud
                <span class="block text-primary">Next Generation Bot Hosting</span>
            </h1>
            <p class="text-slate-400 text-sm md:text-base max-w-xl">
                Platform hosting bot modern dengan integrasi penuh Pterodactyl Panel. Deploy, monitor,
                dan scale bot kamu dalam hitungan detik dengan infrastruktur cloud futuristik.
            </p>
            <div class="flex flex-wrap gap-3">
                <a href="<?php echo $baseUrl; ?>/register" class="btn-primary">
                    Get Started
                </a>
                <a href="<?php echo $baseUrl; ?>/pricing" class="btn-outline">
                    Lihat Paket
                </a>
            </div>
            <div class="flex flex-wrap gap-6 pt-4 text-xs text-slate-400">
                <div>
                    <div class="text-primary text-sm font-semibold">Pterodactyl Powered</div>
                    <div>Panel powerful untuk semua bot dan game server.</div>
                </div>
                <div>
                    <div class="text-primary text-sm font-semibold">Realtime Monitoring</div>
                    <div>Status CPU, RAM, Disk selalu live.</div>
                </div>
            </div>
        </div>
        <div class="space-y-4">
            <?php require dirname(__DIR__) . '/components/terminal.php'; ?>
            <div class="grid grid-cols-3 gap-3 text-xs text-slate-300">
                <div class="rounded-xl border border-white/10 bg-white/5 p-3">
                    <div class="text-slate-400">Active Servers</div>
                    <div class="text-2xl font-semibold mt-1">24</div>
                    <div class="text-emerald-400 mt-1">+3 online</div>
                </div>
                <div class="rounded-xl border border-white/10 bg-white/5 p-3">
                    <div class="text-slate-400">Average CPU</div>
                    <div class="text-2xl font-semibold mt-1">18%</div>
                    <div class="text-slate-500 mt-1">Node optimized</div>
                </div>
                <div class="rounded-xl border border-white/10 bg-white/5 p-3">
                    <div class="text-slate-400">Uptime</div>
                    <div class="text-2xl font-semibold mt-1">99.9%</div>
                    <div class="text-slate-500 mt-1">Last 30 days</div>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="features" class="py-16 border-t border-white/5 bg-gradient-to-b from-black to-slate-950/60">
    <div class="max-w-6xl mx-auto px-4">
        <div class="flex items-center justify-between mb-8">
            <div>
                <h2 class="text-2xl font-semibold">Fitur Utama</h2>
                <p class="text-slate-400 text-sm mt-1">Semua yang kamu butuhkan untuk hosting bot profesional.</p>
            </div>
        </div>
        <div class="grid md:grid-cols-3 gap-6">
            <div class="feature-card">
                <div class="icon-circle">
                    <span class="text-primary">⚡</span>
                </div>
                <h3 class="feature-title">Instant Deploy</h3>
                <p class="feature-text">
                    Server langsung dibuat otomatis via API Pterodactyl. Tanpa setup manual.
                </p>
            </div>
            <div class="feature-card">
                <div class="icon-circle">
                    <span class="text-primary">🛰️</span>
                </div>
                <h3 class="feature-title">Realtime Monitoring</h3>
                <p class="feature-text">
                    CPU, RAM, dan Disk usage di-polling otomatis tiap 5 detik dari panel.
                </p>
            </div>
            <div class="feature-card">
                <div class="icon-circle">
                    <span class="text-primary">🛡️</span>
                </div>
                <h3 class="feature-title">Secure Isolation</h3>
                <p class="feature-text">
                    Setiap bot berjalan di container terisolasi dengan resource terukur.
                </p>
            </div>
        </div>
    </div>
</section>

<section id="status" class="py-16">
    <div class="max-w-6xl mx-auto px-4 grid md:grid-cols-2 gap-10 items-center">
        <div class="space-y-4">
            <h2 class="text-2xl font-semibold">Status Server Live</h2>
            <p class="text-slate-400 text-sm">
                Panel status dengan style terminal log. Pantau kondisi node dan bot secara realtime
                langsung dari dashboard Sherif Cloud.
            </p>
            <ul class="space-y-2 text-sm text-slate-300">
                <li>• Polling status tiap 5 detik</li>
                <li>• Notifikasi jika server down</li>
                <li>• Resource usage detail per server</li>
            </ul>
        </div>
        <div class="live-log-panel rounded-2xl border border-white/10 bg-black/80 p-4">
            <div class="flex items-center justify-between mb-3 text-xs text-slate-400">
                <span>live@sherif-node-01</span>
                <span class="flex items-center gap-2">
                    <span class="h-1.5 w-1.5 rounded-full bg-emerald-400 animate-pulse"></span>
                    <span>All systems operational</span>
                </span>
            </div>
            <div class="live-log-body font-mono text-[11px] text-slate-300 space-y-1">
            </div>
        </div>
    </div>
</section>

