<?php

?><section class="pt-16 pb-20">
    <div class="max-w-6xl mx-auto px-4 space-y-6 text-xs">
        <div>
            <h1 class="text-2xl font-semibold mb-1">Kelola Paket</h1>
            <p class="text-slate-400">
                Paket yang tersedia untuk user Sherif Cloud.
            </p>
        </div>
        <div class="rounded-2xl border border-white/10 bg-black/70 p-4 overflow-x-auto">
            <table class="min-w-full border-collapse">
                <thead class="text-slate-400">
                    <tr>
                        <th class="text-left py-2 pr-4 border-b border-white/10">ID</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Nama</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Slug</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Harga</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">RAM</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Disk</th>
                        <th class="text-left py-2 pr-4 border-b border-white/10">Tipe</th>
                    </tr>
                </thead>
                <tbody class="text-slate-200">
                    <?php foreach ($packages as $package): ?>
                        <tr>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo $package->id; ?></td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo htmlspecialchars($package->name); ?></td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo htmlspecialchars($package->slug); ?></td>
                            <td class="py-2 pr-4 border-b border-white/5">
                                <?php echo $package->is_free ? 'Rp0' : 'Rp' . number_format($package->price, 0, ',', '.'); ?>
                            </td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo $package->memory; ?> MB</td>
                            <td class="py-2 pr-4 border-b border-white/5"><?php echo $package->disk; ?> MB</td>
                            <td class="py-2 pr-4 border-b border-white/5">
                                <?php echo $package->is_free ? 'Free' : 'Premium'; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</section>

