<?php

use App\Core\Auth;
use App\Core\Router;
use App\Controllers\HomeController;
use App\Controllers\AuthController;
use App\Controllers\DashboardController;
use App\Controllers\AdminController;
use App\Controllers\ApiController;
use App\Controllers\PaymentController;
use App\Controllers\VpsController;

spl_autoload_register(function (string $class): void {
    $prefix = 'App\\';
    $baseDir = dirname(__DIR__) . '/app/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relativeClass = substr($class, $len);
    $file = $baseDir . str_replace('\\', DIRECTORY_SEPARATOR, $relativeClass) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

Auth::startSession();

$router = new Router();

$router->get('/', [HomeController::class, 'index']);
$router->get('/pricing', [HomeController::class, 'pricing']);
$router->get('/vps', [VpsController::class, 'index']);

$router->get('/login', [AuthController::class, 'showLogin']);
$router->post('/login', [AuthController::class, 'login']);
$router->get('/register', [AuthController::class, 'showRegister']);
$router->post('/register', [AuthController::class, 'register']);
$router->post('/logout', [AuthController::class, 'logout']);

$router->get('/dashboard', [DashboardController::class, 'index']);
$router->post('/order', [DashboardController::class, 'order']);
$router->post('/vps/order', [VpsController::class, 'order']);

$router->get('/admin', [AdminController::class, 'index']);
$router->get('/admin/users', [AdminController::class, 'users']);
$router->get('/admin/packages', [AdminController::class, 'packages']);
$router->get('/admin/servers', [AdminController::class, 'servers']);

$router->get('/api/server/status', [ApiController::class, 'serverStatus']);
$router->post('/api/server/power', [ApiController::class, 'serverPower']);

$router->get('/payment/callback', [PaymentController::class, 'callback']);
$router->get('/payment/vps-callback', [PaymentController::class, 'vpsCallback']);

$router->dispatch($_SERVER['REQUEST_URI'] ?? '/', $_SERVER['REQUEST_METHOD'] ?? 'GET');
