<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class VpsServer
{
    public int $id;
    public int $user_id;
    public int $vps_plan_id;
    public int $droplet_id;
    public string $name;
    public ?string $ip_address;
    public string $status;

    public static function forUser(int $userId): array
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM vps_servers WHERE user_id = :user_id ORDER BY id DESC');
        $stmt->execute(['user_id' => $userId]);
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return array_map([self::class, 'fromArray'], $rows);
    }

    public static function create(int $userId, int $planId, int $dropletId, string $name, string $status = 'new'): self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('INSERT INTO vps_servers (user_id, vps_plan_id, droplet_id, name, status) VALUES (:user_id, :vps_plan_id, :droplet_id, :name, :status)');
        $stmt->execute([
            'user_id' => $userId,
            'vps_plan_id' => $planId,
            'droplet_id' => $dropletId,
            'name' => $name,
            'status' => $status
        ]);
        $id = (int) $pdo->lastInsertId();
        return self::findById($id);
    }

    public static function findById(int $id): ?self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM vps_servers WHERE id = :id LIMIT 1');
        $stmt->execute(['id' => $id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$data) {
            return null;
        }
        return self::fromArray($data);
    }

    public static function fromArray(array $data): self
    {
        $vps = new self();
        $vps->id = (int) $data['id'];
        $vps->user_id = (int) $data['user_id'];
        $vps->vps_plan_id = (int) $data['vps_plan_id'];
        $vps->droplet_id = (int) $data['droplet_id'];
        $vps->name = $data['name'];
        $vps->ip_address = $data['ip_address'] ?? null;
        $vps->status = $data['status'];
        return $vps;
    }

    public static function updateIpAndStatus(int $id, ?string $ipAddress, string $status): void
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('UPDATE vps_servers SET ip_address = :ip_address, status = :status WHERE id = :id');
        $stmt->execute([
            'ip_address' => $ipAddress,
            'status' => $status,
            'id' => $id
        ]);
    }
}
