<?php

namespace App\Models;

use App\Core\Database;
use PDO;

class VpsPayment
{
    public int $id;
    public int $user_id;
    public int $vps_plan_id;
    public float $amount;
    public string $status;
    public string $provider;
    public ?string $external_id;
    public ?string $redirect_url;
    public string $reference;
    public string $server_name;
    public ?string $image_slug;

    public static function createPending(int $userId, int $planId, float $amount, string $provider, string $reference, string $serverName, ?string $imageSlug): self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('INSERT INTO vps_payments (user_id, vps_plan_id, amount, status, provider, reference, server_name, image_slug) VALUES (:user_id, :vps_plan_id, :amount, :status, :provider, :reference, :server_name, :image_slug)');
        $stmt->execute([
            'user_id' => $userId,
            'vps_plan_id' => $planId,
            'amount' => $amount,
            'status' => 'pending',
            'provider' => $provider,
            'reference' => $reference,
            'server_name' => $serverName,
            'image_slug' => $imageSlug
        ]);
        $id = (int) $pdo->lastInsertId();
        return self::findById($id);
    }

    public static function attachExternal(int $id, string $externalId, string $redirectUrl): void
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('UPDATE vps_payments SET external_id = :external_id, redirect_url = :redirect_url WHERE id = :id');
        $stmt->execute([
            'external_id' => $externalId,
            'redirect_url' => $redirectUrl,
            'id' => $id
        ]);
    }

    public static function markPaidByExternalId(string $externalId): ?self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM vps_payments WHERE external_id = :external_id LIMIT 1');
        $stmt->execute(['external_id' => $externalId]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$data) {
            return null;
        }
        if ($data['status'] === 'paid') {
            return null;
        }

        $stmt = $pdo->prepare('UPDATE vps_payments SET status = :status WHERE external_id = :external_id');
        $stmt->execute([
            'status' => 'paid',
            'external_id' => $externalId
        ]);

        $data['status'] = 'paid';
        return self::fromArray($data);
    }

    public static function findById(int $id): ?self
    {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM vps_payments WHERE id = :id LIMIT 1');
        $stmt->execute(['id' => $id]);
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$data) {
            return null;
        }
        return self::fromArray($data);
    }

    public static function fromArray(array $data): self
    {
        $p = new self();
        $p->id = (int) $data['id'];
        $p->user_id = (int) $data['user_id'];
        $p->vps_plan_id = (int) $data['vps_plan_id'];
        $p->amount = (float) $data['amount'];
        $p->status = $data['status'];
        $p->provider = $data['provider'];
        $p->external_id = $data['external_id'] ?? null;
        $p->redirect_url = $data['redirect_url'] ?? null;
        $p->reference = $data['reference'];
        $p->server_name = $data['server_name'];
        $p->image_slug = $data['image_slug'] ?? null;
        return $p;
    }
}

