<?php

namespace App\Core;

class View
{
    public static function render(string $view, array $params = []): void
    {
        $viewPath = dirname(__DIR__, 2) . '/views/' . str_replace('.', '/', $view) . '.php';
        $layoutPath = dirname(__DIR__, 2) . '/views/layout/main.php';

        extract($params, EXTR_SKIP);
        $authUser = Auth::user();
        $config = require dirname(__DIR__, 2) . '/config/config.php';
        $baseUrl = rtrim($config['app']['base_url'], '/');

        ob_start();
        if (file_exists($viewPath)) {
            require $viewPath;
        } else {
            echo 'View not found';
        }
        $content = ob_get_clean();

        if (file_exists($layoutPath)) {
            require $layoutPath;
        } else {
            echo $content;
        }
    }
}
