<?php

namespace App\Core;

use App\Models\Payment;
use App\Models\Package;
use App\Models\User;
use App\Models\VpsPayment;
use App\Models\VpsPlan;

class PakasirClient
{
    private array $config;

    public function __construct()
    {
        $this->config = require dirname(__DIR__, 2) . '/config/pakasir.php';
    }

    public function isEnabled(): bool
    {
        if (empty($this->config['enabled'])) {
            return false;
        }
        if (empty($this->config['slug']) || $this->config['slug'] === 'YOUR_PAKASIR_SLUG') {
            return false;
        }
        if (empty($this->config['api_key']) || $this->config['api_key'] === 'YOUR_PAKASIR_API_KEY') {
            return false;
        }
        return true;
    }

    public function createInvoice(Payment $payment, User $user, Package $package): ?array
    {
        if (!$this->isEnabled()) {
            return null;
        }

        $baseUrl = rtrim($this->config['base_url'], '/');
        $url = $baseUrl . '/api/payment/create';

        $appConfig = require dirname(__DIR__, 2) . '/config/config.php';
        $callbackBase = rtrim($appConfig['app']['base_url'], '/');
        $callbackUrl = $callbackBase . $this->config['callback_path'];

        $payload = [
            'slug' => $this->config['slug'],
            'api_key' => $this->config['api_key'],
            'amount' => $payment->amount,
            'reference' => $payment->reference,
            'description' => 'Pembayaran paket ' . $package->name . ' untuk ' . $user->email,
            'customer_email' => $user->email,
            'callback_url' => $callbackUrl
        ];

        $ch = curl_init();
        $headers = [
            'Accept: application/json',
            'Content-Type: application/json'
        ];

        $options = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($payload)
        ];

        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);

        if ($response === false) {
            curl_close($ch);
            return null;
        }

        $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($status >= 200 && $status < 300) {
            $decoded = json_decode($response, true);
            return $decoded;
        }

        return null;
    }

    public function createInvoiceForVps(VpsPayment $payment, User $user, VpsPlan $plan): ?array
    {
        if (!$this->isEnabled()) {
            return null;
        }

        $baseUrl = rtrim($this->config['base_url'], '/');
        $url = $baseUrl . '/api/payment/create';

        $appConfig = require dirname(__DIR__, 2) . '/config/config.php';
        $callbackBase = rtrim($appConfig['app']['base_url'], '/');
        $path = $this->config['vps_callback_path'] ?? $this->config['callback_path'];
        $callbackUrl = $callbackBase . $path;

        $payload = [
            'slug' => $this->config['slug'],
            'api_key' => $this->config['api_key'],
            'amount' => $payment->amount,
            'reference' => $payment->reference,
            'description' => 'Pembayaran VPS ' . $plan->name . ' untuk ' . $user->email,
            'customer_email' => $user->email,
            'callback_url' => $callbackUrl
        ];

        $ch = curl_init();
        $headers = [
            'Accept: application/json',
            'Content-Type: application/json'
        ];

        $options = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($payload)
        ];

        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);

        if ($response === false) {
            curl_close($ch);
            return null;
        }

        $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($status >= 200 && $status < 300) {
            $decoded = json_decode($response, true);
            return $decoded;
        }

        return null;
    }
}
