<?php

namespace App\Core;

class Controller
{
    protected array $config;

    public function __construct()
    {
        $this->config = require dirname(__DIR__, 2) . '/config/config.php';
    }

    protected function render(string $view, array $params = []): void
    {
        View::render($view, $params);
    }

    protected function redirect(string $path): void
    {
        $baseUrl = rtrim($this->config['app']['base_url'], '/');
        header('Location: ' . $baseUrl . $path);
        exit;
    }

    protected function requireAuth(): void
    {
        if (!Auth::check()) {
            $this->redirect('/login');
        }
    }

    protected function requireAdmin(): void
    {
        if (!Auth::isAdmin()) {
            $this->redirect('/');
        }
    }
}

