<?php

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Controller;
use App\Core\DigitalOceanClient;
use App\Core\PakasirClient;
use App\Models\VpsPlan;
use App\Models\VpsServer;
use App\Models\User;
use App\Models\VpsPayment;

class VpsController extends Controller
{
    public function index(): void
    {
        $plans = VpsPlan::all();
        $config = require dirname(__DIR__, 2) . '/config/digitalocean.php';
        $this->render('vps/index', [
            'plans' => $plans,
            'doConfig' => $config
        ]);
    }

    public function order(): void
    {
        $this->requireAuth();
        $userData = Auth::user();
        $user = User::findById($userData['id']);

        $planId = (int) ($_POST['plan_id'] ?? 0);
        $plan = VpsPlan::findById($planId);
        if (!$plan) {
            $this->redirect('/vps');
        }

        $imageSlug = $_POST['image_slug'] ?? '';
        $doConfig = require dirname(__DIR__, 2) . '/config/digitalocean.php';
        $allowedImages = $doConfig['images'] ?? [];
        $validImage = null;
        foreach ($allowedImages as $image) {
            if (isset($image['slug']) && $image['slug'] === $imageSlug) {
                $validImage = $image['slug'];
                break;
            }
        }

        $customName = trim($_POST['server_name'] ?? '');
        if ($customName === '') {
            $customName = 'sc-vps-' . $user->id . '-' . time();
        }
        $reference = 'VPS-' . $user->id . '-' . $plan->id . '-' . time();
        $payment = VpsPayment::createPending($user->id, $plan->id, $plan->price, 'pakasir', $reference, $customName, $validImage);

        $pakasir = new PakasirClient();
        $invoice = $pakasir->createInvoiceForVps($payment, $user, $plan);

        if ($invoice && isset($invoice['payment_url'], $invoice['external_id'])) {
            VpsPayment::attachExternal($payment->id, $invoice['external_id'], $invoice['payment_url']);
            $this->redirect($invoice['payment_url']);
            return;
        }

        $this->redirect('/vps');
        $this->redirect('/dashboard');
    }
}
