<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\PterodactylClient;
use App\Core\DigitalOceanClient;
use App\Models\Payment;
use App\Models\Package;
use App\Models\User;
use App\Models\Server;
use App\Models\VpsPayment;
use App\Models\VpsPlan;
use App\Models\VpsServer;

class PaymentController extends Controller
{
    public function callback(): void
    {
        $externalId = $_GET['external_id'] ?? ($_POST['external_id'] ?? null);
        $status = $_GET['status'] ?? ($_POST['status'] ?? null);

        if (!$externalId) {
            http_response_code(400);
            echo 'Missing external_id';
            return;
        }

        if ($status !== 'paid') {
            http_response_code(200);
            echo 'Ignored';
            return;
        }

        $payment = Payment::markPaidByExternalId($externalId);
        if (!$payment) {
            http_response_code(200);
            echo 'Already processed';
            return;
        }

        $user = User::findById($payment->user_id);
        $package = Package::findById($payment->package_id);
        if (!$user || !$package) {
            http_response_code(200);
            echo 'User or package not found';
            return;
        }

        $client = new PterodactylClient();
        $pteroUser = $user->pterodactyl_id;

        if (!$pteroUser) {
            $existing = $client->findUserByEmail($user->email);
            if ($existing && isset($existing['id'])) {
                $pteroUser = (int) $existing['id'];
                User::updatePterodactylId($user->id, $pteroUser);
            } else {
                $createdUser = $client->createUser(
                    $user->email,
                    'user' . $user->id,
                    $user->name,
                    'Cloud',
                    bin2hex(random_bytes(6))
                );
                if ($createdUser && isset($createdUser['attributes']['id'])) {
                    $pteroUser = (int) $createdUser['attributes']['id'];
                    User::updatePterodactylId($user->id, $pteroUser);
                }
            }
        }

        if ($pteroUser) {
            $serverName = 'SherifCloud#' . $user->id . '-' . random_int(1000, 9999);
            $createdServer = $client->createServer(
                $pteroUser,
                $serverName,
                $package->memory,
                $package->disk
            );

            if ($createdServer && isset($createdServer['attributes']['id'], $createdServer['attributes']['identifier'])) {
                Server::createWithPterodactyl(
                    $user->id,
                    $package->id,
                    $serverName,
                    (int) $createdServer['attributes']['id'],
                    $createdServer['attributes']['identifier'],
                    'online'
                );
            }
        }

        http_response_code(200);
        echo 'OK';
    }

    public function vpsCallback(): void
    {
        $externalId = $_GET['external_id'] ?? ($_POST['external_id'] ?? null);
        $status = $_GET['status'] ?? ($_POST['status'] ?? null);

        if (!$externalId) {
            http_response_code(400);
            echo 'Missing external_id';
            return;
        }

        if ($status !== 'paid') {
            http_response_code(200);
            echo 'Ignored';
            return;
        }

        $payment = VpsPayment::markPaidByExternalId($externalId);
        if (!$payment) {
            http_response_code(200);
            echo 'Already processed';
            return;
        }

        $user = User::findById($payment->user_id);
        $plan = VpsPlan::findById($payment->vps_plan_id);
        if (!$user || !$plan) {
            http_response_code(200);
            echo 'User or plan not found';
            return;
        }

        $client = new DigitalOceanClient();
        $response = $client->createDroplet($user, $plan, $payment->server_name, $payment->image_slug);

        if ($response && isset($response['droplet']['id'])) {
            VpsServer::create($user->id, $plan->id, (int) $response['droplet']['id'], $payment->server_name, 'provisioning');
        }

        http_response_code(200);
        echo 'OK';
    }
}
